// Form submission hooks
export { useFormSubmission } from './useFormSubmission';
export type { ApiResponse, UseFormSubmissionOptions } from './useFormSubmission';

// Specific form hooks
export { useContactFormSubmission } from './useContactFormSubmission';
export type { ContactFormData } from './useContactFormSubmission';

export { useAdmissionsFormSubmission } from './useAdmissionsFormSubmission';
export type { AdmissionsFormData } from './useAdmissionsFormSubmission';

export { useNewsletterSubscription } from './useNewsletterSubscription';
export type { NewsletterFormData } from './useNewsletterSubscription';

export { useDonationSubmission } from './useDonationSubmission';
export type { DonationFormData } from './useDonationSubmission';

// Admin hooks
export { useAdminUsers } from './useAdminUsers';
export type { AdminUser } from './useAdminUsers';

export { useContacts, useDeleteContact, useMarkContactAsRead, useSendContactReply } from './useContacts';
export { useAdmissions, useDeleteAdmission, useUpdateAdmissionStatus } from './useAdmissions';
export { useDonations, useDeleteDonation, useCreateManualDonation } from './useDonations';

export { useDebounce } from './useDebounce';

// News hooks (admin panel)
export {
  useNewsArticles,
  useNewsArticle,
  useCreateNewsArticle,
  useUpdateNewsArticle,
  useDeleteNewsArticle,
} from './useNews';

// Teachers hooks (admin panel)
export {
  useTeachers,
  useCreateTeacher,
  useUpdateTeacher,
  useDeleteTeacher,
  teacherSchema,
} from './useTeachers';
export type { Teacher, TeacherFormData } from './useTeachers';

// Leadership hooks (admin panel)
export {
  useLeadership,
  useCreateLeadership,
  useUpdateLeadership,
  useDeleteLeadership,
  leadershipSchema,
} from './useLeadership';
export type { Leadership, LeadershipFormData } from './useLeadership';

// Students hooks (admin panel)
export {
  useStudents,
  useCreateStudent,
  useUpdateStudent,
  useDeleteStudent,
  studentSchema,
} from './useStudents';
export type { Student, StudentFormData } from './useStudents';

// Image upload hook
export { useImageUpload } from './useImageUpload';

// Hero slides hooks
export {
  useHeroSlides,
  usePublicHeroSlides,
  useCreateHeroSlide,
  useUpdateHeroSlide,
  useDeleteHeroSlide,
} from './useHeroSlides';
export type { HeroSlide, HeroSlideInput } from './useHeroSlides';

// Site settings hooks
export {
  useSiteSettings,
  usePublicSiteSettings,
  useUpdateSiteSettings,
} from './useSiteSettings';
export type { SiteSettings } from './useSiteSettings';

// User profile hook
export { useUserProfile } from './useUserProfile';
export type { UserProfile } from './useUserProfile';

