import { useQuery } from "@tanstack/react-query";

export interface AdminUser {
  id: string;
  name: string;
  email: string;
}

export function useAdminUsers() {
  return useQuery({
    queryKey: ["admin-users"],
    queryFn: async () => {
      const res = await fetch("/api/admin/users");
      if (!res.ok) throw new Error("Failed to fetch admin users");
      return res.json();
    },
  });
}
