'use client';

import { useMutation } from '@tanstack/react-query';
import { ApiResponse } from './useFormSubmission';

export interface AdmissionsFormData {
  studentFirstName: string;
  studentLastName: string;
  gradeLevel: string;
  birthDate: string;
  parentName: string;
  parentPhone: string;
  parentEmail: string;
  message?: string;
}

/**
 * Hook for submitting admissions form
 * Handles admissions inquiry submission to /api/forms/admissions
 */
export function useAdmissionsFormSubmission(
  onSuccess?: (data: ApiResponse) => void,
  onError?: (error: Error) => void
) {
  const submitAdmissionsForm = async (values: AdmissionsFormData): Promise<ApiResponse> => {
    const response = await fetch('/api/forms/admissions', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(values),
    });

    const data = await response.json();

    if (!response.ok) {
      throw new Error(data.message || 'Failed to submit admissions form');
    }

    return data;
  };

  return useMutation({
    mutationFn: submitAdmissionsForm,
    onSuccess: (data) => {
      if (onSuccess) {
        onSuccess(data);
      }
    },
    onError: (error) => {
      if (onError) {
        onError(error);
      }
    },
  });
}
