'use client';

import { useMutation } from '@tanstack/react-query';
import { ApiResponse } from './useFormSubmission';

export interface ContactFormData {
  name: string;
  email: string;
  phone?: string;
  subject: string;
  message: string;
}

/**
 * Hook for submitting contact form
 * Handles contact form submission to /api/forms/contact
 */
export function useContactFormSubmission(
  onSuccess?: (data: ApiResponse) => void,
  onError?: (error: Error) => void
) {
  const submitContactForm = async (values: ContactFormData): Promise<ApiResponse> => {
    const response = await fetch('/api/forms/contact', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(values),
    });

    const data = await response.json();

    if (!response.ok) {
      throw new Error(data.message || 'Failed to submit contact form');
    }

    return data;
  };

  return useMutation({
    mutationFn: submitContactForm,
    onSuccess: (data) => {
      if (onSuccess) {
        onSuccess(data);
      }
    },
    onError: (error) => {
      if (onError) {
        onError(error);
      }
    },
  });
}
