'use client';

import { useMutation } from '@tanstack/react-query';
import { ApiResponse } from './useFormSubmission';

export interface DonationFormData {
  donorName: string;
  email: string;
  phone?: string;
  amount: number;
  currency: string;
  category?: string;
  message?: string;
  paymentMethod: string;
  anonymous?: boolean;
}

/**
 * Hook for donation submission
 * Handles donation form submission to /api/forms/donate
 */
export function useDonationSubmission(
  onSuccess?: (data: ApiResponse) => void,
  onError?: (error: Error) => void
) {
  const submitDonation = async (values: DonationFormData): Promise<ApiResponse> => {
    const response = await fetch('/api/forms/donate', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(values),
    });

    const data = await response.json();

    if (!response.ok) {
      throw new Error(data.message || 'Failed to submit donation');
    }

    return data;
  };

  return useMutation({
    mutationFn: submitDonation,
    onSuccess: (data) => {
      if (onSuccess) {
        onSuccess(data);
      }
    },
    onError: (error) => {
      if (onError) {
        onError(error);
      }
    },
  });
}
