import { useMutation } from '@tanstack/react-query';

export interface ApiResponse<T = unknown> {
  success: boolean;
  message: string;
  data?: T;
  errors?: Record<string, string>;
}

export interface UseFormSubmissionOptions<TData, TVariables> {
  mutationFn: (variables: TVariables) => Promise<TData>;
  onSuccess?: (data: TData) => void;
  onError?: (error: Error) => void;
}

/**
 * Generic hook for form submissions with React Query
 * Handles loading, error, and success states
 */
export function useFormSubmission<TData extends ApiResponse, TVariables>(
  options: UseFormSubmissionOptions<TData, TVariables>
) {
  return useMutation({
    mutationFn: options.mutationFn,
    onSuccess: (data) => {
      if (options.onSuccess) {
        options.onSuccess(data);
      }
    },
    onError: (error) => {
      if (options.onError) {
        options.onError(error);
      }
    },
  });
}
