'use client';

import { useMutation } from '@tanstack/react-query';
import { ApiResponse } from './useFormSubmission';

export interface NewsletterFormData {
  email: string;
  firstName?: string;
}

/**
 * Hook for newsletter subscription
 * Handles newsletter signup to /api/forms/newsletter
 */
export function useNewsletterSubscription(
  onSuccess?: (data: ApiResponse) => void,
  onError?: (error: Error) => void
) {
  const submitNewsletter = async (values: NewsletterFormData): Promise<ApiResponse> => {
    const response = await fetch('/api/forms/newsletter', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(values),
    });

    const data = await response.json();

    if (!response.ok) {
      throw new Error(data.message || 'Failed to subscribe to newsletter');
    }

    return data;
  };

  return useMutation({
    mutationFn: submitNewsletter,
    onSuccess: (data) => {
      if (onSuccess) {
        onSuccess(data);
      }
    },
    onError: (error) => {
      if (onError) {
        onError(error);
      }
    },
  });
}
