'use client';

import { useQuery, UseQueryResult } from '@tanstack/react-query';
import { useAuth } from '@/context/auth-context';

export interface UserProfile {
  id: string;
  name: string;
  email: string;
  role: string;
  avatar?: string;
  bio?: string;
  phone?: string;
  department?: string;
  status: string;
  active: boolean;
  createdAt: Date;
  updatedAt: Date;
  lastLogin?: Date;
}

interface ApiResponse<T> {
  success: boolean;
  message: string;
  data: T;
}

const fetchUserProfile = async (): Promise<UserProfile> => {
  const response = await fetch('/api/admin/profile/me', {
    method: 'GET',
    headers: { 'Content-Type': 'application/json' },
  });

  const data = (await response.json()) as ApiResponse<UserProfile>;

  if (!response.ok) {
    throw new Error(data.message || 'Failed to fetch profile');
  }

  return data.data;
};

export function useUserProfile(): UseQueryResult<UserProfile, Error> {
  const { isAuthenticated } = useAuth();

  return useQuery({
    queryKey: ['user-profile'],
    queryFn: fetchUserProfile,
    enabled: isAuthenticated,
    staleTime: 1000 * 60 * 10, // 10 minutes
    gcTime: 1000 * 60 * 15, // 15 minutes (formerly cacheTime)
    retry: 1,
    refetchOnWindowFocus: false,
  });
}
