import {
  sendUserApprovalEmail,
  sendUserRejectionEmail,
  sendUserSuspensionEmail,
  sendAccountReactivationEmail,
} from '@/lib/email';

const NEXTAUTH_URL = process.env.NEXTAUTH_URL || 'http://localhost:3000';

/**
 * Send approval email to newly approved admin user
 */
export async function notifyUserApproved(
  email: string,
  userName: string
) {
  const loginUrl = `${NEXTAUTH_URL}/auth/signin`;
  return sendUserApprovalEmail(email, userName, loginUrl);
}

/**
 * Send rejection email to rejected user
 */
export async function notifyUserRejected(
  email: string,
  userName: string,
  reason?: string
) {
  return sendUserRejectionEmail(email, userName, reason);
}

/**
 * Send suspension email to suspended user
 */
export async function notifyUserSuspended(
  email: string,
  userName: string,
  reason?: string
) {
  return sendUserSuspensionEmail(email, userName, reason);
}

/**
 * Send reactivation email to reactivated user
 */
export async function notifyAccountReactivated(
  email: string,
  userName: string
) {
  const loginUrl = `${NEXTAUTH_URL}/auth/signin`;
  return sendAccountReactivationEmail(email, userName, loginUrl);
}

export const emailNotifications = {
  notifyUserApproved,
  notifyUserRejected,
  notifyUserSuspended,
  notifyAccountReactivated,
};
