import * as Yup from "yup";

export const NEWS_CATEGORIES = [
  "Academics",
  "Facilities",
  "Faculty",
  "Sports",
  "Community",
  "Arts",
  "Events",
];

export const NEWS_THEMES = [
  "primary",
  "secondary",
  "accent",
  "success",
  "danger",
  "dark",
];

export const NEWS_ARTICLE_SCHEMA = Yup.object({
  title: Yup.string()
    .min(10, "Title must be at least 10 characters long")
    .required("Title is required")
    .max(100, "Title must be at most 100 characters long"),
  excerpt: Yup.string()
    .min(50, "Excerpt must be at least 50 characters long")
    .required("Excerpt is required")
    .max(150, "Excerpt must be at most 150 characters long"),
  content: Yup.string()
    .min(100, "Content must be at least 100 characters long")
    .test("not-empty", "Content is required", (value) => {
      return !!value && value !== "<p></p>" && value.trim().length > 0;
    })
    .required("Content is required"),
  category: Yup.string()
    .oneOf(NEWS_CATEGORIES, "Invalid category")
    .required("Category is required"),
  theme: Yup.string()
    .oneOf(NEWS_THEMES, "Invalid theme")
    .default("primary"),
  tags: Yup.array(Yup.string())
    .min(0, "At least one tag is recommended")
    .max(10, "Maximum 10 tags allowed"),
  status: Yup.string()
    .oneOf(["draft", "published"], "Invalid status")
    .required("Status is required"),
  readTime: Yup.number()
    .min(1, "Read time must be at least 1 minute")
    .max(60, "Read time cannot exceed 60 minutes")
    .required("Read time is required"),
});