/**
 * Admin Panel Type Definitions
 * 
 * IMPORTANT: This file contains ALL admin-specific types.
 * Keep isolated from public types for easy migration.
 */

// ==================== AUTH TYPES ====================
export interface AdminUser {
  id: string;
  email: string;
  name: string;
  role: 'super_admin' | 'admin' | 'editor';
  avatar?: string;
  createdAt: Date;
  updatedAt: Date;
}

export interface AdminSession {
  user: AdminUser;
  token: string;
  expiresAt: Date;
}

// ==================== NEWS TYPES ====================
export interface NewsArticle {
  id: string;
  title: string;
  slug: string;
  excerpt: string;
  content: string;
  coverImage: string;
  category: string;
  tags: string[];
  author: {
    id: string;
    name: string;
    avatar?: string;
  };
  status: 'draft' | 'published' | 'archived';
  publishedAt?: Date;
  createdAt: Date;
  updatedAt: Date;
}

export interface NewsCategory {
  id: string;
  name: string;
  slug: string;
  description?: string;
  count: number;
}

// ==================== TEACHER TYPES ====================
export interface Teacher {
  id: string;
  name: string;
  gender: 'male' | 'female';
  email?: string;
  phone?: string;
  subject: string;
  experience: string;
  achievement: string;
  bio: string;
  image: string;
  qualifications: string[];
  status: 'active' | 'inactive';
  createdAt: Date;
  updatedAt: Date;
}

// ==================== STUDENT TYPES ====================
export interface Student {
  id: string;
  name: string;
  story: string;
  image: string;
  need: string;
  background: string;
  contact?: string;
  status: 'active' | 'supported' | 'graduated';
  createdAt: Date;
  updatedAt: Date;
}

// ==================== CONTACT TYPES ====================
export interface ContactSubmission {
  id: string;
  name: string;
  email: string;
  phone?: string;
  subject: string;
  message: string;
  status: 'new' | 'read' | 'replied' | 'archived';
  repliedAt?: Date;
  repliedBy?: string;
  createdAt: Date;
}

// ==================== DONATION TYPES ====================
export interface Donation {
  id: string;
  donorName: string;
  donorEmail: string;
  amount: number;
  currency: string;
  paymentMethod: string;
  purpose?: string;
  studentId?: string;
  status: 'pending' | 'completed' | 'failed';
  transactionId?: string;
  createdAt: Date;
}

// ==================== MEDIA TYPES ====================
export interface MediaFile {
  id: string;
  filename: string;
  originalName: string;
  url: string;
  mimeType: string;
  size: number;
  uploadedBy: string;
  category: 'image' | 'document' | 'video';
  createdAt: Date;
}

// ==================== SETTINGS TYPES ====================
export interface SiteSettings {
  id: string;
  siteName: string;
  siteDescription: string;
  contactEmail: string;
  contactPhone: string;
  address: string;
  socialMedia: {
    facebook?: string;
    twitter?: string;
    instagram?: string;
    whatsapp?: string;
  };
  updatedAt: Date;
  updatedBy: string;
}

// ==================== DASHBOARD TYPES ====================
export interface DashboardStats {
  totalStudents: number;
  totalTeachers: number;
  totalNews: number;
  totalDonations: number;
  pendingContacts: number;
  recentActivities: Activity[];
}

export interface Activity {
  id: string;
  type: 'news' | 'teacher' | 'student' | 'contact' | 'donation';
  action: 'created' | 'updated' | 'deleted';
  description: string;
  user: string;
  createdAt: Date;
}

// ==================== API RESPONSE TYPES ====================
export interface ApiResponse<T> {
  success: boolean;
  data?: T;
  error?: string;
  message?: string;
}

export interface PaginatedResponse<T> {
  data: T[];
  pagination: {
    page: number;
    pageSize: number;
    total: number;
    totalPages: number;
  };
}

// ==================== FORM TYPES ====================
export interface NewsFormData {
  title: string;
  slug: string;
  excerpt: string;
  content: string;
  coverImage: string;
  category: string;
  tags: string[];
  status: 'draft' | 'published';
}

export interface TeacherFormData {
  name: string;
  gender: 'male' | 'female';
  email?: string;
  phone?: string;
  subject: string;
  experience: string;
  achievement: string;
  bio: string;
  image: string;
  qualifications: string[];
}

export interface StudentFormData {
  name: string;
  story: string;
  image: string;
  need: string;
  background: string;
  contact?: string;
}
