// Common type definitions
export type Placement = 
  | 'top'
  | 'top start'
  | 'top end'
  | 'bottom'
  | 'bottom start'
  | 'bottom end'
  | 'left'
  | 'left start'
  | 'left end'
  | 'right'
  | 'right start'
  | 'right end';

export interface BaseComponentProps {
  className?: string;
  children?: React.ReactNode;
}

export interface DropdownOption {
  value: string;
  label: string;
  disabled?: boolean;
}

// Student in Need Type
export interface StudentInNeed {
  id: string;
  name: string;
  grade?: string | null;
  year?: string | null;
  story: string;
  background?: string | null;
  specificNeed?: string | null;
  achievements?: string | null;
  image?: string | null;
  needCategory: string;
  contactInfo?: string | null;
  featured: boolean;
  createdAt: Date;
  updatedAt: Date;
}
